'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Bild22_Click()
On Error GoTo Err_Bild22_Click_Click

    DoCmd.OpenForm "Impressum"

Exit_Bild22_Click_Click:
    Exit Sub

Err_Bild22_Click_Click:
    MsgBox err.Description
    Resume Exit_Bild22_Click_Click

End Sub

Private Sub Button_Auswertungen_Click()
On Error GoTo Err_Button_Auswertungen_Click

    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint

    Dim stDocName As String
    Dim stLinkCriteria As String

    stDocName = "Auswertungen"
    DoCmd.OpenForm stDocName, , , stLinkCriteria

Exit_Button_Auswertungen_Click:
    Exit Sub

Err_Button_Auswertungen_Click:
    MsgBox err.Description
    Resume Exit_Button_Auswertungen_Click

End Sub

Private Sub Button_Einstellungen_Click()
On Error GoTo Err_Button_Einstellungen_Click

    Dim stDocName As String
    Dim stLinkCriteria As String
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint

    stDocName = "Einstellungen"
    DoCmd.OpenForm stDocName, , , stLinkCriteria

Exit_Button_Einstellungen_Click:
    Exit Sub

Err_Button_Einstellungen_Click:
    MsgBox err.Description
    Resume Exit_Button_Einstellungen_Click

End Sub

Private Sub Button_Ende_Click()
On Error GoTo Err_Button_Ende_Click


    DoCmd.Quit

Exit_Button_Ende_Click:
    Exit Sub

Err_Button_Ende_Click:
    MsgBox err.Description
    Resume Exit_Button_Ende_Click
    
End Sub

Private Sub Button_Kalender_Click()
On Error GoTo Err_Button_Kalender_Click

    'Prfen, ob Termintabelle leer ist
    Set dbs = CurrentDb
    Set rst = dbs.OpenRecordset("Termine")
    If rst.RecordCount = 0 Then
        rst.Close
        Set dbs = Nothing
        MsgBox "Es wurden noch keine Termine von Outlook bernommen.", vbInformation, "Hinweis"
        Exit Sub
    End If
    rst.Close
    Set dbs = Nothing
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint

    Dim stDocName As String
    Dim stLinkCriteria As String

    stDocName = "Kalender"
    DoCmd.OpenForm stDocName, , , stLinkCriteria

Exit_Button_Kalender_Click:
    Exit Sub

Err_Button_Kalender_Click:
    MsgBox err.Description
    Resume Exit_Button_Kalender_Click


End Sub

Private Sub Button_Kategorien_Click()
On Error GoTo Err_Button_Kategorien_Click

    'Prfen, ob Kundentabelle leer ist
    Set dbs = CurrentDb
    Set rst = dbs.OpenRecordset("Kategorien")
    If rst.RecordCount = 0 Then
        rst.Close
        Set dbs = Nothing
        MsgBox "Es wurden noch keine Termine von Outlook bernommen.", vbInformation, "Hinweis"
        Exit Sub
    End If
    rst.Close
    Set dbs = Nothing
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint

    Dim stDocName As String
    Dim stLinkCriteria As String

    stDocName = "Kategorien"
    DoCmd.OpenForm stDocName, , , stLinkCriteria

Exit_Button_Kategorien_Click:
    Exit Sub

Err_Button_Kategorien_Click:
    MsgBox err.Description
    Resume Exit_Button_Kategorien_Click

End Sub

Private Sub Button_Kunden_Click()
On Error GoTo Err_Button_Kunden_Click

    'Prfen, ob Kundentabelle leer ist
    Set dbs = CurrentDb
    Set rst = dbs.OpenRecordset("Kunden")
    If rst.RecordCount = 0 Then
        rst.Close
        Set dbs = Nothing
        MsgBox "Es wurden noch keine Kundendaten von Outlook bernommen.", vbInformation, "Hinweis"
        Exit Sub
    End If
    rst.Close
    Set dbs = Nothing
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint

    Dim stDocName As String
    Dim stLinkCriteria As String

    stDocName = "Kunden"
    DoCmd.OpenForm stDocName, , , stLinkCriteria

Exit_Button_Kunden_Click:
    Exit Sub

Err_Button_Kunden_Click:
    MsgBox err.Description
    Resume Exit_Button_Kunden_Click

End Sub

Private Sub Button_Rechnungen_Click()
On Error GoTo Err_Button_Rechnungen_Click

    Dim stDocName As String
    Dim stLinkCriteria As String
    Dim Textfilter, Statustext As String
    Dim Abbruch As Variant
    
    'letzten Aktualisierungsstatus holen und wenn ungleich "OK": Warnung ausgeben
    Textfilter = "SELECT * FROM Aktualisierungen ORDER BY Start"
    Set dbs = CurrentDb
    Set rst = dbs.OpenRecordset(Textfilter)
    If (rst.RecordCount > 0) Then
        rst.MoveLast
        Statustext = UCase(rst!Status)
        rst.Close
        Set dbs = Nothing
        If UCase(Statustext) <> "OK" Then
            If (UCase(Statustext) = "WARNUNG") And (TerminOhneKontakt_verarbeiten = "W") Then
                Beep
                If MsgBox("Die letzte Aktualisierung hatte den Status:   *** " & Statustext & " ***" & vbNewLine & vbNewLine & _
                        "ACHTUNG:" & vbNewLine & "Bei der letzten Aktualisierung wurde mindestens ein Termin bernommen, " & _
                        "dem kein Kontakt zugeordnet ist! " & vbNewLine & vbNewLine & _
                        "Mchten Sie den Rechnungslauf trotzdem durchfhren?", vbYesNo + vbDefaultButton2 + vbExclamation, "Achtung!") = vbNo Then
                    Exit Sub
                End If
            Else
                'If TerminOhneKontakt_verarbeiten <> "I" Then
                    Beep
                    If MsgBox("Die letzte Aktualisierung hatte den Status:   *** " & Statustext & " ***" & vbNewLine & vbNewLine & _
                            "ACHTUNG:" & vbNewLine & "Durch die unvollstndige Aktualisierung sind die internen Daten mglicherweise " & _
                            "nicht konsistent. Sie sollten diesen Datenstand nicht fr eine Abrechnung nutzen! " & _
                            "Es wird empfohlen, die Aktualisierung zu wiederholen, bis sie erfolgreich ist." & vbNewLine & vbNewLine & _
                            "Mchten Sie den Rechnungslauf trotzdem durchfhren?", vbYesNo + vbDefaultButton2 + vbExclamation, "Achtung!") = vbNo Then
                        Exit Sub
                    End If
                'End If
            End If
        End If
    Else
        rst.Close
        Set dbs = Nothing
    End If
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint

    stDocName = "Rechnungslaufparameter"
    DoCmd.OpenForm stDocName, , , stLinkCriteria

Exit_Button_Rechnungen_Click:
    Exit Sub

Err_Button_Rechnungen_Click:
    MsgBox err.Description
    Resume Exit_Button_Rechnungen_Click

End Sub

Private Sub Button_Rechnungen_drucken_Click()
    If MsgBox("Wollen Sie die noch nicht gedruckten Rechnungen jetzt drucken?", vbYesNo + vbDefaultButton2 + vbQuestion, "Rechnungen drucken...") = vbNo Then Exit Sub
    ReUngedrucktAlle = True
    ReKopieAnzahl = 0
    ReKopieZeitpunkt = 999
    ReLaufArt = 999
    RechnungenDrucken
    'Ansicht aktualisieren
    Form_Activate
    
End Sub

Private Sub Button_Termine_einlesen_Click()
On Error GoTo Err_Button_Termine_einlesen_Click

    Dim stDocName As String
    Dim stLinkCriteria As String
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint

    stDocName = "Outlook_einlesen"
    DoCmd.OpenForm stDocName, , , stLinkCriteria

Exit_Button_Termine_einlesen_Click:
    Exit Sub

Err_Button_Termine_einlesen_Click:
    MsgBox err.Description
    Resume Exit_Button_Termine_einlesen_Click
    
End Sub

Private Sub Form_Activate()
    Dim dbs As Database, rst As Recordset
    Dim Textfilter, TextMeldung As String
    Dim RechnungenUngedruckt As Long
    Dim ErrDataBase As String
    Dim ErrDataField As String
    
    On Error GoTo Err_Form_Activate
    
    
    
    TextMeldung = ""
    
    Set dbs = CurrentDb
    ErrDataBase = "Einstellungen"
    ErrDataField = "<Tabelle ffnen>"
    Set rst = dbs.OpenRecordset("Einstellungen")
    
    'Raumbezeichnung anzeigen
    ErrDataField = "Raumbezeichnung"
    If Not IsNull(rst!Raumbezeichnung) Then
        Me.Raumname.Caption = Trim(rst!Raumbezeichnung)
    Else
        Me.Raumname.Caption = "Einstellungen: Menname?"
    End If
    
    'Eintellung der Schriftart fr Berichte merken
    ErrDataField = "Schriftart"
    If IsNull(rst!Schriftart) Then
        SchriftArtWahl = "Arial"
    Else
        SchriftArtWahl = Trim(rst!Schriftart)
    End If
    
    'Internen Stundensatz fr Auswertungen merken
    ErrDataField = "InternerStdSatz"
    If IsNull(rst!InternerStdSatz) Then
        InternerStundenSatz = 0
    Else
        InternerStundenSatz = rst!InternerStdSatz
    End If
    
    'monatsbergreifende Termine auf der Re. splitten?
    ErrDataField = "ReMonatssplittingTermin"
    ReTerminMonatssplitting = False
    If IsNull(rst!ReMonatssplittingTermin) Then
        ReTerminMonatssplitting = False
    Else
        ReTerminMonatssplitting = rst!ReMonatssplittingTermin
    End If
    
    'Zeitverzgerung fr "Serien"-Drucke merken
    ErrDataField = "Druckverzoegerung"
    If IsNull(rst!Druckverzoegerung) Then
        Verzoegerung = 0
    Else
        Verzoegerung = rst!Druckverzoegerung
    End If
    
    'vor welchem Jahr drfen keine nderungen durchgefhrt werden?
    ErrDataField = "NichtVorJahr"
    KeineAenderungenVorJahrX = 0
    If IsNull(rst!NichtVorJahr) Then
        KeineAenderungenVorJahrX = 0
    Else
        KeineAenderungenVorJahrX = rst!NichtVorJahr
    End If
    
    'Einstellungen zur "Km"-Verarbeitung merken
    ErrDataField = "km_JaNein"
    If IsNull(rst!km_JaNein) Then
        km_Erfassung = False
    Else
        km_Erfassung = rst!km_JaNein
    End If
    
    ErrDataField = "km_Text"
    If IsNull(rst!km_Text) Then
        km_RechText = ""
    Else
        km_RechText = Trim(rst!km_Text)
    End If
    
    ErrDataField = "km_TabKuerzel"
    If IsNull(rst!km_TabKuerzel) Then
        km_TabellenKuerzel = ""
    Else
        km_TabellenKuerzel = Trim(rst!km_TabKuerzel)
    End If
    
    ErrDataField = "km_DezTrenner"
    If IsNull(rst!km_DezTrenner) Then
        km_DezimalTrenner = "S"
    Else
        km_DezimalTrenner = Left(Trim(rst!km_DezTrenner), 1)
    End If
    If (km_DezimalTrenner = "S") Or (km_DezimalTrenner = "s") Then
        'bei Einstellung "System", das Trennzeichen vom System ermitteln
        km_DezimalTrenner = Mid(Format(0, "0.00"), 2, 1)
    End If
    
    ErrDataField = "km_Nachkomma"
    If IsNull(rst!km_Nachkomma) Then
        km_DezimalAnzahl = 0
    Else
        km_DezimalAnzahl = rst!km_Nachkomma
    End If
    
    ErrDataField = "km_Verwendung"
    If IsNull(rst!km_Verwendung) Then
        km_Verwendungen = 0
    Else
        ' 0 = nur Statistik
        ' 1 = Nachweis & Statistik
        ' 2 = Rechnung & Statistik
        km_Verwendungen = rst!km_Verwendung
    End If
    
    'Ansichtseinstellung fr Listen merken
    'rst!GraueZeile ist ein negativer Offset zu 255 (wird von Wei abgezogen)
    'Je hher der Wert, desto dunkler ist der Zeilenhintergrund.
    ErrDataField = "GraueZeile"
    If IsNull(rst!GraueZeile) Then
        ZeilenGrau = 255    'wei (nicht sichtbar)
    Else
        ZeilenGrau = 255 - (rst!GraueZeile * 3)
        If ZeilenGrau < 0 Then ZeilenGrau = 0
    End If
    
    'FormularNr fr Rechnung und Storno merken
    ErrDataField = "Rechnungsformular"
    If IsNull(rst!Rechnungsformular) Then
        FormularRechnung = 0
    Else
        FormularRechnung = rst!Rechnungsformular
    End If
    
    ErrDataField = "Stornoformular"
    If IsNull(rst!Stornoformular) Then
        FormularStorno = 0
    Else
        FormularStorno = rst!Stornoformular
    End If
    FormularRechnungName = "Rechnung_" & Format(FormularRechnung, "000") & "_Hauptformular"
    FormularStornoName = "Storno_" & Format(FormularStorno, "000") & "_Hauptformular"
    
    
    'Zeitformat fr Termindauer merken
    ' 0 = Minuten           (Bsp.: 105)
    ' 4 = Dezimalstunden    (1,75)
    ' 8 = Std:Min           (01:45)
    ErrDataField = "Zeitformat"
    If IsNull(rst!Zeitformat) Then
        FormatTermindauer = 0
    Else
        FormatTermindauer = rst!Zeitformat
    End If
    
    'Nachkommastellen fr Stundensaetze merken
    ' nur zwischen 0 und 4 erlauben
    ErrDataField = "StdSatzNachkomma"
    If IsNull(rst!StdSatzNachkomma) Then
        NachkommaStdSatz = 4    'Standardwert sind 4 Nachkommastellen
    Else
        NachkommaStdSatz = rst!StdSatzNachkomma
    End If
    If NachkommaStdSatz < 0 Then NachkommaStdSatz = 0
    If NachkommaStdSatz > 4 Then NachkommaStdSatz = 4
    
    'Verarbeitung privater Termine merken
    ErrDataField = "TerminPrivat"
    If IsNull(rst!TerminPrivat) Then
        Privat_verarbeiten = False
    Else
        Privat_verarbeiten = rst!TerminPrivat
    End If
    
    'Verarbeitung Termine ohne Kontaktverknpfung merken
    ' F = Fehlermeldung
    ' W = Warnung ausgeben (+ Dummy-Kontakt)
    ' I = ignorieren & bergehen (+ Dummy-Kontakt)
    ErrDataField = "TerminOhneKontakt"
    If IsNull(rst!TerminOhneKontakt) Then
        TerminOhneKontakt_verarbeiten = "I"
    Else
        TerminOhneKontakt_verarbeiten = rst!TerminOhneKontakt
    End If
    
    'Vorrangregelung fr indiv. MwSt merken
    ' 0 = Kunden-MwSt vor Kategorie-MwSt (vor Standard-MwSt)
    ' 1 = Kategorie-MwSt vor Kunden-MwSt (vor Standard-MwSt)
    ErrDataField = "MwSt_Prioritaet"
    ReMwStPrioritaet = rst!MwSt_Prioritaet
    
    ErrDataField = "MsSt_Kuerzel"
    If IsNull(rst!MwSt_Kuerzel) Then
        ReMwStKuerzel = "MwSt"
    Else
        ReMwStKuerzel = rst!MwSt_Kuerzel
    End If
    
    'Wenn die Preisberechnung nach Kategorien oder Kalendern erfolgen soll
    ErrDataField = "PreisJeKategorie_JaNein"
    RePreisJeKategorie = rst!PreisJeKategorie_JaNein
    ErrDataField = "PreisJeKalender_JaNein"
    RePreisJeKalender = rst!PreisJeKalender_JaNein
    
    'Einstellungen fr QR-Code merken
    ErrDataField = "QR_JaNein"
    If IsNull(rst!QR_JaNein) Then
        QRjanein = True
    Else
        QRjanein = rst!QR_JaNein
    End If
    
    ErrDataField = "QR_Position"
    If IsNull(rst!QR_Position) Then         ' [R]echts, [M]ittig, [L]inks
        QRposition = "R"
    Else
        QRposition = Trim(rst!QR_Position)
        If Len(QRposition) = 0 Then
            QRposition = "R"
        Else
            If InStr(1, "LMR", QRposition) < 1 Then QRposition = "R"
        End If
    End If
    
    ErrDataField = "QR_Zoom"
    If IsNull(rst!QR_Zoom) Then
        QRzoom = 0
    Else
        QRzoom = rst!QR_Zoom
        If (QRzoom < -5) Or (QRzoom > 5) Then QRzoom = 0
    End If
    
    ErrDataField = "QR_Flaeche"
    If IsNull(rst!QR_Flaeche) Then
        QRflaeche = 89                      ' QR-Code nimmt 89 Prozent des Rahmens ein
    Else
        QRflaeche = rst!QR_Flaeche
        If (QRflaeche < 70) Or (QRflaeche > 99) Then QRflaeche = 89
    End If
    
    ErrDataField = "QR_Versatz"
    If IsNull(rst!QR_Versatz) Then
        QRversatz = 0.01                    ' manuelle Korrektur der Position um 0,01 Prozent der QR-Code-Breite
    Else
        QRversatz = rst!QR_Versatz
        If (QRversatz < 0) Or (QRversatz > 0.2) Then QRversatz = 0.01
    End If
    
    ErrDataField = "QR_Text"
    If IsNull(rst!QR_Text) Then
        QRtext = "Re. [ReNr] vom [ReDatum], [Name1]"
    Else
        QRtext = Trim(rst!QR_Text)
        If Len(QRtext) = 0 Then QRtext = "Re. [ReNr] vom [ReDatum], [Name1]"
    End If
    
    ErrDataField = "<Tabelle schlieen>"
        
    rst.Close
    
    
    'Einstellungen zur Benutzung von Kategorievorgaben laden
    ErrDataBase = "Einst_Kategorien"
    ErrDataField = "<Tabelle ffnen>"
    Set rst = dbs.OpenRecordset("Einst_Kategorien")
        ErrDataField = "Datei"
        If IsNull(rst!Datei) Then
            KatListeDatei = ""
        Else
            KatListeDatei = rst!Datei
        End If
        ErrDataField = "Uebernahme"
        KatUebernahmeArt = rst!Uebernahme
        ErrDataField = "KategorieWo"
        KatOrt = rst!KategorieWo
        ErrDataField = "WoVon"
        KatWoVon = rst!WoVon
        ErrDataField = "WoBis"
        KatWoBis = rst!WoBis
        ErrDataField = "Trennzeichen"
        KatTrennzeichen = rst!Trennzeichen
        ErrDataField = "Anfuehrung"
        KatAnfuehrung = rst!Anfuehrung
        ErrDataField = "AutoEinlesen_JN"
        KatAutoEinlesen = rst!AutoEinlesen_JN
        ErrDataField = "LeereLoeschen_JN"
        KatLeereLoeschen = rst!LeereLoeschen_JN
        ErrDataField = "StrengePruefung"
        KatStrengePruefung = rst!StrengePruefung
        ErrDataField = "<Tabelle schlieen>"
    rst.Close
    
    
    'ID-Nummer des Dummy-Kontakts und der Dummy-Kategorie in der Datenbank
    KontaktDummy = "0123456789DUMMY9876543210"
    KategorieDummy = "0123456789DUMMY9876543210"
    'Kontakte
    ErrDataBase = "Kunden"
    ErrDataField = "<Tabelle ffnen>"
    Textfilter = "SELECT * FROM Kunden WHERE [Kunden_ID]='" & KontaktDummy & "'"
    Set rst = dbs.OpenRecordset(Textfilter)
    ErrDataField = "lfd_Nr"
    SatzKontaktDummy = rst!lfd_Nr
    ErrDataField = "<Tabelle schlieen>"
    rst.Close
    'Kategorien
    ErrDataBase = "Kategorien"
    ErrDataField = "<Tabelle ffnen>"
    Textfilter = "SELECT * FROM Kategorien WHERE [Kategorie_ID]='" & KategorieDummy & "'"
    Set rst = dbs.OpenRecordset(Textfilter)
    ErrDataField = "lfd_Nr"
    SatzKategorieDummy = rst!lfd_Nr
    ErrDataField = "<Tabelle schlieen>"
    rst.Close
        
    'berschriften fr Rechnungs- und Stornoformular holen
    ErrDataBase = "FormRechnungen"
    ErrDataField = "<Tabelle ffnen>"
    Textfilter = "SELECT * FROM FormRechnungen WHERE [Formularnummer]=" & FormularRechnung
    Set rst = dbs.OpenRecordset(Textfilter)
    If rst.RecordCount = 0 Then
        FormularRechnungUeberschrift = "Rechnung"
    Else
        ErrDataField = "Ueberschrift"
        FormularRechnungUeberschrift = rst!Ueberschrift
    End If
    ErrDataField = "<Tabelle schlieen>"
    rst.Close
    ErrDataBase = "FormStornos"
    ErrDataField = "<Tabelle ffnen>"
    Textfilter = "SELECT * FROM FormStornos WHERE [Formularnummer]=" & FormularStorno
    Set rst = dbs.OpenRecordset(Textfilter)
    If rst.RecordCount = 0 Then
        FormularStornoUeberschrift = "STORNO zu Rechnung"
    Else
        ErrDataField = "Ueberschrift"
        FormularStornoUeberschrift = rst!Ueberschrift
    End If
    ErrDataField = "<Tabelle schlieen>"
    rst.Close
    
    'Vorgaben fr Farbeinstellungen
    Farbflaeche = ""
    FarbeAendern = False
    Farbverlaufsfaktor = 1
    ErrDataBase = "Einstellungen2"
    ErrDataField = "<Tabelle ffnen>"
    Textfilter = "SELECT * FROM Einstellungen2"
    Set rst = dbs.OpenRecordset(Textfilter)
    If (rst.RecordCount > 0) Then
        ErrDataField = "<MoveFirst>"
        rst.MoveFirst
        ErrDataField = "<div. Farbinformationen>"
        'Balkendiagramm positive Werte
        RGB_PlusRot = rst!BalkenPositiv_R
        RGB_PlusGruen = rst!BalkenPositiv_G
        RGB_PlusBlau = rst!BalkenPositiv_B
        'Balkendiagramm negative Werte
        RGB_MinusRot = rst!BalkenNegativ_R
        RGB_MinusGruen = rst!BalkenNegativ_G
        RGB_MinusBlau = rst!BalkenNegativ_B
        'Kreissegmente 1 bis 8 (und Erstellung Farbverlauf bei Farbauswahl)
        RGB_Rot1 = rst!Kreis1_R
        RGB_Rot2 = rst!Kreis2_R
        RGB_Rot3 = rst!Kreis3_R
        RGB_Rot4 = rst!Kreis4_R
        RGB_Rot5 = rst!Kreis5_R
        RGB_Rot6 = rst!Kreis6_R
        RGB_Rot7 = rst!Kreis7_R
        RGB_Rot8 = rst!Kreis8_R
        RGB_Gruen1 = rst!Kreis1_G
        RGB_Gruen2 = rst!Kreis2_G
        RGB_Gruen3 = rst!Kreis3_G
        RGB_Gruen4 = rst!Kreis4_G
        RGB_Gruen5 = rst!Kreis5_G
        RGB_Gruen6 = rst!Kreis6_G
        RGB_Gruen7 = rst!Kreis7_G
        RGB_Gruen8 = rst!Kreis8_G
        RGB_Blau1 = rst!Kreis1_B
        RGB_Blau2 = rst!Kreis2_B
        RGB_Blau3 = rst!Kreis3_B
        RGB_Blau4 = rst!Kreis4_B
        RGB_Blau5 = rst!Kreis5_B
        RGB_Blau6 = rst!Kreis6_B
        RGB_Blau7 = rst!Kreis7_B
        RGB_Blau8 = rst!Kreis8_B
        'weitere Kreisbedingungen
        KreisrestProzent = rst!KreisProzentRest
        KreisZeichnen = rst!KreisJaNein
        'Matrix Kalender/Kategorien
        Matrix_KalenderKategorie_ExcelJaNein = rst!MatrixKalKatExcel_JN
        If IsNull(rst!MatrixKalKatExcel_Datei) Then
            Matrix_KalenderKategorie_ExcelDatei = ""
        Else
            Matrix_KalenderKategorie_ExcelDatei = Trim(rst!MatrixKalKatExcel_Datei)
        End If
    End If
    ErrDataField = "<Tabelle schlieen>"
    rst.Close
    
    
    'vorerst fr Testzwecke
    Mehrfachwahl_Primaer = "Kalender"       ' oder "Kategorie"
       
       
       
       
       
    Me.Repaint
    
    
    TextMeldung = ""
    
    'letzte Aktualisierung anzeigen
    ErrDataBase = "Aktualisierungen"
    ErrDataField = "<Tabelle ffnen>"
    Textfilter = "SELECT * FROM Aktualisierungen ORDER BY Start"
    Set rst = dbs.OpenRecordset(Textfilter)
    If (rst.RecordCount > 0) Then
        ErrDataField = "<MoveLast>"
        rst.MoveLast
        ErrDataField = "Start, Status"
        TextMeldung = "Letzte Aktualisierung: " & rst!Start & " -> " & rst!Status & "."
    End If
    ErrDataField = "<Tabelle schlieen>"
    rst.Close
    
    'letzten Rechnungslauf anzeigen
    ErrDataBase = "Rechnungslaeufe"
    ErrDataField = "<Tabelle ffnen>"
    Textfilter = "SELECT * FROM Rechnungslaeufe ORDER BY Start"
    Set rst = dbs.OpenRecordset(Textfilter)
    If (rst.RecordCount > 0) Then
        ErrDataField = "<MoveLast>"
        rst.MoveLast
        ErrDataField = "Start, Re_Anzahl"
        If Len(TextMeldung) > 0 Then
            TextMeldung = TextMeldung & vbNewLine & "Letzter Rechnungslauf: " & rst!Start & " -> " & rst!Re_Anzahl & " Rechnung(en)."
        Else
            TextMeldung = "Letzter Rechnungslauf: " & rst!Start & " -> " & rst!Re_Anzahl & " Rechnung(en)."
        End If
    End If
    ErrDataField = "<Tabelle schlieen>"
    rst.Close
    
    
    'Anzahl nicht gedruckter Rechnungen anzeigen
    ErrDataBase = "Rechnungen"
    ErrDataField = "<Tabelle ffnen>"
    Textfilter = "SELECT * FROM Rechnungen WHERE (((gedruckt)=False))"
    Set rst = dbs.OpenRecordset(Textfilter)
    If (rst.RecordCount <> 0) Then
        ErrDataField = "<MoveLast>"
        rst.MoveLast
        ErrDataField = "<RecordCount>"
        If Len(TextMeldung) > 0 Then
            TextMeldung = TextMeldung & vbNewLine & "Nicht gedruckte Rechnung(en): " & rst.RecordCount & "."
        Else
            TextMeldung = "Nicht gedruckte Rechnung(en): " & rst.RecordCount & "."
        End If
        Me.Button_Rechnungen_drucken.Visible = True
    Else
        Me.Button_Termine_einlesen.SetFocus
        Me.Button_Rechnungen_drucken.Visible = False
    End If
    ErrDataField = "<Tabelle schlieen>"
    rst.Close
    
    'Set dbs = Nothing
    
    Me.Meldungsfeld.Caption = TextMeldung
    Me.Repaint
    
    KalkulationAusOutlookUebernahme = False

    'Impressum-Texte generieren
    ErrDataBase = "<Impressum>"
    ErrDataField = "<Fuss>"
    ImpressumBerichtsfuss = ""
    ImpressumBerichtsfuss = Chr(xECKEauf Xor 255) & Chr(xTgross Xor 255) & Chr(xEklein Xor 255) & Chr(xRklein Xor 255)
    ImpressumBerichtsfuss = ImpressumBerichtsfuss & Chr(xMklein Xor 255) & Chr(xIklein Xor 255) & Chr(xNklein Xor 255)
    ImpressumBerichtsfuss = ImpressumBerichtsfuss & Chr(xAklein Xor 255) & Chr(xBklein Xor 255) & Chr(xRklein Xor 255)
    ImpressumBerichtsfuss = ImpressumBerichtsfuss & Chr(xEklein Xor 255) & Chr(xCklein Xor 255) & Chr(xHklein Xor 255)
    ImpressumBerichtsfuss = ImpressumBerichtsfuss & Chr(xNklein Xor 255) & Chr(xUklein Xor 255) & Chr(xNklein Xor 255)
    ImpressumBerichtsfuss = ImpressumBerichtsfuss & Chr(xGklein Xor 255) & Chr(xLeer Xor 255) & Chr(xMINUS Xor 255)
    ImpressumBerichtsfuss = ImpressumBerichtsfuss & Chr(xLeer Xor 255) & Chr(xRUNDauf Xor 255) & Chr(xCklein Xor 255)
    ImpressumBerichtsfuss = ImpressumBerichtsfuss & Chr(xRUNDzu Xor 255) & Chr(xLeer Xor 255) & Chr(xZWEI Xor 255)
    ImpressumBerichtsfuss = ImpressumBerichtsfuss & Chr(xNULL Xor 255) & Chr(xEINS Xor 255) & Chr(xNEUN Xor 255)
    ImpressumBerichtsfuss = ImpressumBerichtsfuss & Chr(xLeer Xor 255) & Chr(xJgross Xor 255) & Chr(xEklein Xor 255)
    ImpressumBerichtsfuss = ImpressumBerichtsfuss & Chr(xNklein Xor 255) & Chr(xSklein Xor 255) & Chr(xMINUS Xor 255)
    ImpressumBerichtsfuss = ImpressumBerichtsfuss & Chr(xCgross Xor 255) & Chr(xHklein Xor 255) & Chr(xRklein Xor 255)
    ImpressumBerichtsfuss = ImpressumBerichtsfuss & Chr(xIklein Xor 255) & Chr(xSklein Xor 255) & Chr(xTklein Xor 255)
    ImpressumBerichtsfuss = ImpressumBerichtsfuss & Chr(xIklein Xor 255) & Chr(xAklein Xor 255) & Chr(xNklein Xor 255)
    ImpressumBerichtsfuss = ImpressumBerichtsfuss & Chr(xLeer Xor 255) & Chr(xWgross Xor 255) & Chr(xAklein Xor 255)
    ImpressumBerichtsfuss = ImpressumBerichtsfuss & Chr(xWklein Xor 255) & Chr(xRklein Xor 255) & Chr(xCklein Xor 255)
    ImpressumBerichtsfuss = ImpressumBerichtsfuss & Chr(xZklein Xor 255) & Chr(xEklein Xor 255) & Chr(xCklein Xor 255)
    ImpressumBerichtsfuss = ImpressumBerichtsfuss & Chr(xKklein Xor 255) & Chr(xECKEzu Xor 255)
    
    ErrDataField = "<Name>"
    ImpressumName = ""
    ImpressumName = ImpressumName & Chr(xJgross Xor 255) & Chr(xEklein Xor 255)
    ImpressumName = ImpressumName & Chr(xNklein Xor 255) & Chr(xSklein Xor 255) & Chr(xMINUS Xor 255)
    ImpressumName = ImpressumName & Chr(xCgross Xor 255) & Chr(xHklein Xor 255) & Chr(xRklein Xor 255)
    ImpressumName = ImpressumName & Chr(xIklein Xor 255) & Chr(xSklein Xor 255) & Chr(xTklein Xor 255)
    ImpressumName = ImpressumName & Chr(xIklein Xor 255) & Chr(xAklein Xor 255) & Chr(xNklein Xor 255)
    ImpressumName = ImpressumName & Chr(xLeer Xor 255) & Chr(xWgross Xor 255) & Chr(xAklein Xor 255)
    ImpressumName = ImpressumName & Chr(xWklein Xor 255) & Chr(xRklein Xor 255) & Chr(xCklein Xor 255)
    ImpressumName = ImpressumName & Chr(xZklein Xor 255) & Chr(xEklein Xor 255) & Chr(xCklein Xor 255)
    ImpressumName = ImpressumName & Chr(xKklein Xor 255)
    
    ErrDataField = "<Telefon>"
    ImpressumTelefon = ""
    ImpressumTelefon = ImpressumTelefon & Chr(xPLUS Xor 255) & Chr(xVIER Xor 255) & Chr(xNEUN Xor 255)
    ImpressumTelefon = ImpressumTelefon & Chr(xLeer Xor 255) & Chr(xRUNDauf Xor 255) & Chr(xNULL Xor 255)
    ImpressumTelefon = ImpressumTelefon & Chr(xRUNDzu Xor 255) & Chr(xDREI Xor 255) & Chr(xZWEI Xor 255)
    ImpressumTelefon = ImpressumTelefon & Chr(xEINS Xor 255) & Chr(xZWEI Xor 255) & Chr(xLeer Xor 255)
    ImpressumTelefon = ImpressumTelefon & Chr(xEINS Xor 255) & Chr(xZWEI Xor 255) & Chr(xSECHS Xor 255)
    ImpressumTelefon = ImpressumTelefon & Chr(xFUENF Xor 255) & Chr(xNULL Xor 255)
    ImpressumTelefon = ImpressumTelefon & Chr(xDREI Xor 255) & Chr(xACHT Xor 255)
    
    ErrDataField = "<Internet>"
    ImpressumInternet = ""
    ImpressumInternet = ImpressumInternet & Chr(xWklein Xor 255) & Chr(xWklein Xor 255) & Chr(xWklein Xor 255)
    ImpressumInternet = ImpressumInternet & Chr(xPUNKT Xor 255) & Chr(xJgross Xor 255) & Chr(xEklein Xor 255)
    ImpressumInternet = ImpressumInternet & Chr(xNklein Xor 255) & Chr(xSklein Xor 255) & Chr(xMINUS Xor 255)
    ImpressumInternet = ImpressumInternet & Chr(xWgross Xor 255) & Chr(xAklein Xor 255) & Chr(xWklein Xor 255)
    ImpressumInternet = ImpressumInternet & Chr(xRklein Xor 255) & Chr(xCklein Xor 255) & Chr(xZklein Xor 255)
    ImpressumInternet = ImpressumInternet & Chr(xEklein Xor 255) & Chr(xCklein Xor 255) & Chr(xKklein Xor 255)
    ImpressumInternet = ImpressumInternet & Chr(xPUNKT Xor 255) & Chr(xDklein Xor 255) & Chr(xEklein Xor 255)
    
    ErrDataField = "<EMail>"
    ImpressumEMail = ""
    ImpressumEMail = ImpressumEMail & Chr(xIklein Xor 255) & Chr(xNklein Xor 255) & Chr(xFklein Xor 255)
    ImpressumEMail = ImpressumEMail & Chr(xOklein Xor 255)
    ImpressumEMail = ImpressumEMail & Chr(xMAIL Xor 255) & Chr(xJgross Xor 255) & Chr(xEklein Xor 255)
    ImpressumEMail = ImpressumEMail & Chr(xNklein Xor 255) & Chr(xSklein Xor 255) & Chr(xMINUS Xor 255)
    ImpressumEMail = ImpressumEMail & Chr(xWgross Xor 255) & Chr(xAklein Xor 255) & Chr(xWklein Xor 255)
    ImpressumEMail = ImpressumEMail & Chr(xRklein Xor 255) & Chr(xCklein Xor 255) & Chr(xZklein Xor 255)
    ImpressumEMail = ImpressumEMail & Chr(xEklein Xor 255) & Chr(xCklein Xor 255) & Chr(xKklein Xor 255)
    ImpressumEMail = ImpressumEMail & Chr(xPUNKT Xor 255) & Chr(xDklein Xor 255) & Chr(xEklein Xor 255)
        
    
    
    On Error Resume Next
    ErrDataBase = "<div. Masken>"
    ErrDataField = "<schlieen>"
    DoCmd.Close acForm, "Datenbankpfad_eingeben", acSaveNo
    DoCmd.Close acForm, "Outlook_einlesen", acSaveNo
    DoCmd.Close acForm, "Kunden", acSaveNo
    DoCmd.Close acForm, "Kategorien", acSaveNo
    DoCmd.Close acForm, "Rechnungslaufparameter", acSaveNo
    DoCmd.Close acForm, "Auswertungen", acSaveNo
    DoCmd.Close acForm, "Einstellungen", acSaveYes
    DoCmd.Close acForm, "Einstellungen_2", acSaveYes
    DoCmd.Close acForm, "Einstellungen_3", acSaveYes
    DoCmd.Close acForm, "Einstellungen_4", acSaveYes
    DoCmd.Close acForm, "Programmstart", acSaveNo
    DoCmd.Close acForm, "Programmstart_A2007Option", acSaveNo
    
    
    
    Exit Sub
    
    
    
Err_Form_Activate:
    MsgBox "Bei der Verarbeitung des Datenfeldes [" & ErrDataField & "] der Tabelle [" & ErrDataBase & "] trat ein Fehler auf." & _
        vbNewLine & "Bitte kontaktieren Sie den Hersteller zwecks Fehleranalyse und Bereinigung." & _
        vbNewLine & vbNewLine & "Fehler # " & err.Number & " verursacht in " & err.Source & " => " & err.Description, vbExclamation + vbOKOnly, "Achtung"
    'MsgBox err.Description
    Resume Next
    
End Sub

Private Sub Form_Open(Cancel As Integer)
    'Fehlermeldung verhindern, falls Starthinweis bereits geschlossen wurde,
    'weil der Datenbankpfad abgefragt wird
    On Error Resume Next
    'Benutzerhinweis anzeigen
    DoCmd.OpenForm "Programmstart"
    Forms![Programmstart].Repaint
End Sub

Private Sub Rechnungsbuch_Click()
On Error GoTo Err_Rechnungsbuch_Click

    'Prfen, ob Rechnungstabelle leer ist
    Set dbs = CurrentDb
    Set rst = dbs.OpenRecordset("Rechnungen")
    If rst.RecordCount = 0 Then
        rst.Close
        Set dbs = Nothing
        MsgBox "Es wurden noch keine Rechnungen generiert.", vbInformation, "Hinweis"
        Exit Sub
    End If
    rst.Close
    Set dbs = Nothing
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint

    Dim stDocName As String
    Dim stLinkCriteria As String

    stDocName = "Rechnungen_Uebersicht"
    DoCmd.OpenForm stDocName, , , stLinkCriteria

Exit_Rechnungsbuch_Click:
    Exit Sub

Err_Rechnungsbuch_Click:
    MsgBox err.Description
    Resume Exit_Rechnungsbuch_Click
    
End Sub
Private Sub Button_DatenbenkUebersicht_Click()
On Error GoTo Err_Button_DatenbenkUebersicht_Click

    Dim stDocName As String
    Dim stLinkCriteria As String
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint

    'Gre des Reportfensters und Berichts-Zoom optimieren
    'erst Fensterbreite und -hhe ermitteln, und nach dem ffnen des Reports anpassen
    AnwendungGroesseErmitteln

    'Variable vorbelegen
    FehlerFormularOeffnen = False

    'Maske ffnen
    stDocName = "Datenbank_Explorer"
    DoCmd.OpenForm stDocName, , , stLinkCriteria

    If FehlerFormularOeffnen Then
        On Error Resume Next
        DoCmd.Close acForm, "Datenbank_Explorer", acSaveNo
        DoCmd.Close acForm, "Bitte_warten", acSaveNo
    Else
        'Maske nun auf Anwendunghhe zoomen
        DoCmd.MoveSize , 0, , FormularHoehe
    End If


Exit_Button_DatenbenkUebersicht_Click:
    Exit Sub

Err_Button_DatenbenkUebersicht_Click:
    MsgBox err.Description
    Resume Exit_Button_DatenbenkUebersicht_Click
    
End Sub
